/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.palette;

import filenet.vw.api.VWAttachment;
import filenet.vw.api.VWException;
import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWStepPaletteDefinition;
import filenet.vw.apps.designer.VWDesignerCoreData;
import filenet.vw.apps.designer.VWSaveOptionDialog;
import filenet.vw.base.VWDebug;
import filenet.vw.base.VWString;
import filenet.vw.idm.toolkit.IVWIDMDialog;
import filenet.vw.idm.toolkit.IVWIDMDocument;
import filenet.vw.idm.toolkit.IVWIDMFactory;
import filenet.vw.idm.toolkit.IVWIDMItem;
import filenet.vw.idm.toolkit.VWIDMBaseFactory;
import filenet.vw.toolkit.design.palette.resources.VWResource;
import filenet.vw.toolkit.utils.VWStepUtils;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.swing.JOptionPane;

public class VWStepPaletteWrapper {
    protected static final Dimension DIM_SAVE_DIALOG = new Dimension(500, 200);
    protected static final int TYPE_PREDEFINED_BPM = 0;
    protected static final int TYPE_MY_PALETTE = 1;
    protected static final int TYPE_CUSTOM_PALETTE = 2;
    private boolean m_bIsDirty = false;
    private boolean m_bIsEditable = false;
    private String m_name = null;
    private int m_nType = 2;
    private String m_resourceName = null;
    private VWStepPaletteDefinition m_vwStepPaletteDef = null;
    private VWDesignerCoreData m_designerCoreData = null;
    private IVWIDMDocument m_IDMDoc = null;
    private String m_filePath = null;

    public VWStepPaletteWrapper(int nType, String resourceName, VWDesignerCoreData designerCoreData) {
        int nIndex;
        if (nType >= 0 && nType <= 2) {
            this.m_nType = nType;
            if (nType == 1) {
                this.m_name = VWResource.s_myPaletteOption;
                this.m_resourceName = VWResource.s_myPaletteOption;
                this.m_bIsEditable = true;
                try {
                    this.loadStepPaletteFromStream(null);
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                }
            }
        }
        if (resourceName != null && resourceName.length() > 0 && (nIndex = resourceName.lastIndexOf("/")) != -1) {
            this.m_resourceName = resourceName.substring(nIndex + 1, resourceName.length());
        }
        this.m_designerCoreData = designerCoreData;
    }

    public String getName() {
        if (this.m_name != null && this.m_name.length() > 0) {
            return this.m_name;
        }
        return this.m_vwStepPaletteDef.getName();
    }

    public int getType() {
        return this.m_nType;
    }

    public String getResourceName() {
        return this.m_resourceName;
    }

    public String getFileNameToolTip() {
        if (this.m_IDMDoc != null) {
            VWString checkoutMode = this.m_IDMDoc.isCheckedOut() ? VWResource.s_checkedOutPrompt : VWResource.s_copyPrompt;
            return checkoutMode.toString(this.m_IDMDoc.getLabel(), this.m_designerCoreData.getSessionInfo().isWorkPlaceWebApp() ? this.m_IDMDoc.getVersionNumber() : this.m_IDMDoc.getIdWithVer());
        }
        return this.m_filePath;
    }

    public String getFileName() {
        int nIndex;
        if (this.m_IDMDoc != null) {
            return this.m_IDMDoc.getLabel();
        }
        if (this.m_filePath != null && this.m_filePath.length() > 0 && (nIndex = this.m_filePath.lastIndexOf("\\")) != -1) {
            return this.m_filePath.substring(nIndex + 1, this.m_filePath.length());
        }
        return this.m_filePath;
    }

    public VWStepPaletteDefinition getStepPaletteDefinition() {
        return this.m_vwStepPaletteDef;
    }

    public void setStepPaletteDefinition(VWStepPaletteDefinition vwStepPaletteDef) {
        this.m_vwStepPaletteDef = vwStepPaletteDef;
        this.m_bIsDirty = false;
        this.m_bIsEditable = false;
        this.m_IDMDoc = null;
        this.m_filePath = null;
    }

    public boolean isCheckedOut() {
        return this.m_IDMDoc != null && this.m_IDMDoc.isCheckedOut();
    }

    public boolean isDirty() {
        return this.m_bIsDirty;
    }

    public boolean isEditable() {
        return this.m_bIsEditable;
    }

    public String toString() {
        return this.getName();
    }

    public void loadStepPaletteFromStream(InputStream inStream) throws Exception {
        this.m_vwStepPaletteDef = inStream != null ? VWStepPaletteDefinition.read(inStream) : new VWStepPaletteDefinition();
        if (this.m_vwStepPaletteDef.getName() == null) {
            this.m_vwStepPaletteDef.setName(VWResource.s_myPaletteOption);
        }
        this.m_bIsDirty = false;
        this.m_IDMDoc = null;
        this.m_filePath = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadStepPaletteFromFile(String filePath) throws Exception {
        block6: {
            File paletteFile = null;
            if (filePath != null) {
                paletteFile = new File(filePath);
            }
            if (paletteFile != null && paletteFile.exists()) {
                FileInputStream inStream = null;
                try {
                    inStream = new FileInputStream(filePath);
                    this.loadStepPaletteFromStream(inStream);
                    Object var5_4 = null;
                    if (inStream == null) break block6;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    if (inStream != null) {
                        inStream.close();
                    }
                    throw throwable;
                }
                inStream.close();
            } else {
                this.loadStepPaletteFromStream(null);
            }
        }
        this.m_filePath = filePath;
    }

    public boolean openFileNetDocument(Frame parentFrame, VWAttachment vwAttachment) {
        if (vwAttachment != null) {
            String library = vwAttachment.getLibraryName();
            String docId = vwAttachment.getId();
            String version = vwAttachment.getVersion();
            if (library != null && library.length() > 0) {
                try {
                    IVWIDMDocument IDMDoc;
                    IVWIDMFactory idmFactory = VWIDMBaseFactory.instance();
                    if (idmFactory != null && (IDMDoc = idmFactory.getIDMDocument(library, docId, version)) != null) {
                        int confirmResult;
                        boolean bCheckItOut = false;
                        bCheckItOut = IDMDoc.isExclusiveLockOwner() ? true : (IDMDoc.canCheckin() ? (confirmResult = JOptionPane.showConfirmDialog(parentFrame, VWResource.s_assumeCheckOut, VWResource.s_fnOpenTitle, 0)) == 0 : IDMDoc.canCheckout());
                        this.readFileNETDocument(IDMDoc, bCheckItOut);
                    }
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                    VWMessageDialog.showOptionDialog(parentFrame, ex.getLocalizedMessage(), VWResource.s_fnOpenErrTitle, 1);
                    return false;
                }
            }
        }
        return true;
    }

    public void releaseReferences() {
        this.m_name = null;
        this.m_vwStepPaletteDef = null;
        this.m_designerCoreData = null;
        this.m_IDMDoc = null;
        this.m_filePath = null;
    }

    protected void addStep(VWMapNode newMapNode) throws Exception {
        block11: {
            if (newMapNode == null || !this.m_bIsEditable) {
                return;
            }
            if (this.m_vwStepPaletteDef == null) {
                this.m_vwStepPaletteDef = new VWStepPaletteDefinition();
            }
            try {
                VWMapNode[] mapNodes = this.m_vwStepPaletteDef.getSteps();
                if (mapNodes == null) break block11;
                int nNewStepType = VWStepUtils.getAttributeStepType(newMapNode, false);
                for (int nIndex = 0; nIndex < mapNodes.length; ++nIndex) {
                    if (nNewStepType != VWStepUtils.getAttributeStepType(mapNodes[nIndex], false) || VWStringUtils.compare(newMapNode.getName(), mapNodes[nIndex].getName()) != 0) continue;
                    int nResult = JOptionPane.showConfirmDialog(this.m_designerCoreData.getParentFrame(), VWResource.s_stepAlreadyExists, VWResource.s_conflict, 1, 3);
                    switch (nResult) {
                        case 0: {
                            this.m_vwStepPaletteDef.deleteStep(mapNodes[nIndex].getStepId());
                            break;
                        }
                        case 2: {
                            return;
                        }
                    }
                    break;
                }
            }
            catch (VWException ex) {
                // empty catch block
            }
        }
        StringBuffer stringBuf = new StringBuffer();
        newMapNode.toXML(stringBuf);
        VWMapNode[] newSteps = this.m_vwStepPaletteDef.pasteSteps(stringBuf.toString());
        if (newSteps != null && newSteps.length > 0) {
            for (int i = 0; i < newSteps.length; ++i) {
                VWStepUtils.getAttributeStepType(newSteps[i], true);
            }
        }
        this.m_designerCoreData.getCoordinationEventNotifier().sendCoordinationEvent(this, 750, null);
        this.m_bIsDirty = true;
    }

    protected void removeStep(VWMapNode vwMapNode, Frame parent) {
        try {
            if (!this.m_bIsEditable || this.m_vwStepPaletteDef == null || vwMapNode == null) {
                return;
            }
            this.m_vwStepPaletteDef.deleteStep(vwMapNode.getStepId());
            this.m_designerCoreData.getCoordinationEventNotifier().sendCoordinationEvent(this, 751, null);
            this.m_bIsDirty = true;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(parent, ex.getLocalizedMessage(), VWResource.s_error, 1);
        }
    }

    protected void copySteps(VWStepPaletteDefinition vwDestStepPaletteDef) {
        if (this.m_vwStepPaletteDef != null && vwDestStepPaletteDef != null) {
            try {
                VWMapNode[] vwMapNodes = this.m_vwStepPaletteDef.getSteps();
                if (vwMapNodes != null && vwMapNodes.length > 0) {
                    StringBuffer stringBuf = new StringBuffer();
                    for (int nIndex = 0; nIndex < vwMapNodes.length; ++nIndex) {
                        try {
                            vwMapNodes[nIndex].toXML(stringBuf);
                            continue;
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                    vwDestStepPaletteDef.pasteSteps(stringBuf.toString());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void saveStepPaletteToFile(String filePath) throws Exception {
        if (this.m_vwStepPaletteDef != null) {
            this.m_vwStepPaletteDef.setName(this.getName());
            this.m_vwStepPaletteDef.writeToFile(filePath);
            this.m_bIsDirty = false;
            this.m_IDMDoc = null;
            this.m_filePath = filePath;
        }
    }

    protected String getCanonicalName() {
        if (this.m_IDMDoc != null) {
            try {
                VWAttachment vwAttachment = this.m_IDMDoc.getVWAttachment();
                if (vwAttachment != null) {
                    return vwAttachment.toString();
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }
        return null;
    }

    protected IVWIDMDocument getIDMDocument() {
        return this.m_IDMDoc;
    }

    protected boolean browseAndopenFileNetDocument(IVWIDMItem IDMContext) throws Exception {
        String[] resources = VWStringUtils.getResourcesFromString(VWResource.s_open_withHK);
        IVWIDMDialog dialog = VWIDMBaseFactory.instance().getOpenDialog(IDMContext, resources[0]);
        dialog.setTitle(VWResource.s_openFromDMSTitle);
        dialog.setButtonMnemonic(resources[1]);
        dialog.setButtonTooltip(VWResource.s_open);
        if (dialog.showDialog(this.m_designerCoreData.getParentFrame()) == 0) {
            boolean bCheckItOut;
            IVWIDMDocument IDMDoc = (IVWIDMDocument)dialog.getSelectedItem();
            boolean bl = bCheckItOut = dialog.getMode() == 1;
            if (!bCheckItOut && IDMDoc.canCheckin()) {
                int confirmResult = JOptionPane.showConfirmDialog(this.m_designerCoreData.getParentFrame(), VWResource.s_assumeCheckOut, VWResource.s_fnOpenTitle, 0);
                boolean bl2 = bCheckItOut = confirmResult == 0;
            }
            if (IDMDoc == null) {
                return false;
            }
            this.readFileNETDocument(IDMDoc, bCheckItOut);
        }
        return true;
    }

    protected boolean addFileNetDocument(Frame parentFrame, IVWIDMItem IDMContext) throws Exception {
        if (this.checkInOrCancelCheckOut(parentFrame, VWResource.s_continueWithAddNew)) {
            if (this.m_vwStepPaletteDef == null) {
                this.m_vwStepPaletteDef = new VWStepPaletteDefinition();
            }
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            this.m_vwStepPaletteDef.write(outStream);
            byte[] fileContents = outStream.toByteArray();
            IVWIDMDialog dialog = VWIDMBaseFactory.instance().getAddDialog(parentFrame, IDMContext, fileContents, "StepPalette");
            dialog.setTitle(VWResource.s_AddToDMSTitle);
            dialog.setFilename(this.getName());
            if (dialog.showDialog(parentFrame) == 0) {
                this.m_bIsDirty = false;
                this.m_IDMDoc = (IVWIDMDocument)dialog.getSelectedItem();
                if (this.m_IDMDoc != null && this.m_IDMDoc.canCheckout() && !this.m_IDMDoc.isCheckedOut()) {
                    this.m_IDMDoc.checkoutNoUI();
                }
                return true;
            }
        }
        return false;
    }

    protected boolean checkInFileNetDocument(Frame parentFrame) throws Exception {
        if (this.m_IDMDoc != null && this.m_IDMDoc.isCheckedOut() && this.m_IDMDoc.canCheckin()) {
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            this.m_vwStepPaletteDef.write(outStream);
            byte[] fileContents = outStream.toByteArray();
            try {
                if (!this.m_IDMDoc.checkin(parentFrame, fileContents, true, this.getName(), VWResource.s_checkinStepPaletteDefinition)) {
                    return false;
                }
                this.m_bIsDirty = false;
            }
            catch (Exception ex) {
                try {
                    if (outStream != null) {
                        outStream.close();
                    }
                }
                catch (Exception ex2) {
                    // empty catch block
                }
                throw ex;
            }
        }
        return true;
    }

    protected void cancelFileNetDocumentCheckOut() throws Exception {
        if (this.m_IDMDoc != null && this.m_IDMDoc.isCheckedOut() && this.m_IDMDoc.canCancelCheckout()) {
            this.m_IDMDoc.cancelCheckoutNoUI();
        }
    }

    protected void saveCheckedOutFileNetDocument() throws Exception {
        if (this.m_IDMDoc != null && this.m_IDMDoc.isCheckedOut() && this.m_IDMDoc.canCheckin()) {
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            this.m_vwStepPaletteDef.write(outStream);
            byte[] fileContents = outStream.toByteArray();
            this.m_IDMDoc.saveContents(fileContents, this.getName());
            this.m_bIsDirty = false;
        }
    }

    protected boolean checkInOrCancelCheckOut(Frame parentFrame, String optionStr) throws Exception {
        if (this.m_IDMDoc != null && this.m_IDMDoc.isCheckedOut() && this.m_IDMDoc.canCheckin()) {
            parentFrame.setVisible(true);
            Toolkit.getDefaultToolkit().beep();
            VWSaveOptionDialog saveOptionDialog = new VWSaveOptionDialog(parentFrame, VWResource.s_mainWindowTitle, 1, optionStr, true);
            saveOptionDialog.setSize(DIM_SAVE_DIALOG);
            saveOptionDialog.setVisible(true);
            switch (saveOptionDialog.getStatus()) {
                case 1: {
                    return false;
                }
                case 0: {
                    if (saveOptionDialog.getChoice() == 2) {
                        this.checkInFileNetDocument(parentFrame);
                        break;
                    }
                    this.cancelFileNetDocumentCheckOut();
                }
            }
        }
        return true;
    }

    private void readFileNETDocument(IVWIDMDocument IDMDoc, boolean bCheckItOut) throws Exception {
        if (IDMDoc != null) {
            this.m_IDMDoc = IDMDoc;
            byte[] fileContents = this.m_IDMDoc.getContents(bCheckItOut);
            if (fileContents != null) {
                ByteArrayInputStream inStream = new ByteArrayInputStream(fileContents);
                this.m_vwStepPaletteDef = VWStepPaletteDefinition.read(inStream);
                inStream.close();
            } else {
                this.m_vwStepPaletteDef = new VWStepPaletteDefinition();
            }
            this.m_bIsDirty = false;
        }
    }
}

